;;;  Dateiname: LAMPENBAZAR.lsp  -  erstellt: Thomas Elbracht
;;;  6.2025  -  fr AC2023           mail: te@elbracht-web.de
;;;  Aufruf mit: LAMPENBAZAR
;;;
;;;  Die Routine erstellt Lampen fr den Einrichtungsplaner
;;;
;;;  Das Programm wird dem Benutzer so zur Verfgung gestellt, "wie es ist".
;;;  Fr eventuelle Programmfehler oder Schden durch die Anwendung
;;;  wird keine Haftung bernommen.
;;
(defun Te:lampenbazarIni ()
  
  (if *error*				
    (setq *te:error* *error*)		
  )

  (setq cealt (getvar "CMDECHO")
        mealt (getvar "MENUECHO")
	osalt (getvar "OSMODE")
	ortalt (getvar "ORTHOMODE")
	layalt (getvar "CLAYER")
	coalt (getvar "CECOLOR")
	cesalt (getvar "CELTSCALE")
	celalt (getvar "CELTYPE")
	delalt (getvar "DELOBJ")
	surft1alt (getvar "SURFTAB1")
	)
 	(setvar "CMDECHO" 0)
	(setvar "MENUECHO" 0)
  	(setvar "OSMODE" 0)
        (setvar "ORTHOMODE" 0)
        (setvar "DELOBJ" 2)
  	
  (defun *error* (sTxt)	
    (princ (strcat "\n" sTxt))

  (setvar "CMDECHO" cealt)
  (setvar "MENUECHO" mealt)
  (setvar "OSMODE" osalt)
  (setvar "CLAYER"  layalt)
  (setvar "CECOLOR" coalt)
  (setvar "ORTHOMODE" ortalt)
  (setvar "DELOBJ" delalt)
  (setvar "SURFTAB1" surft1alt)
   
    (if	*te:error*
      (setq *error* *te:error*)	
      (setq *error* nil)
    )
    (princ)
  )
nil
)
(defun TE:lampenbazarDlg ( / dcl_id)

(setq next 4)
(setq px (car EP) py (cadr EP) pz (caddr EP))
(setq IMG1 "lampenbazar(logo)"
      fil1 IMG1
  ) 
(if (not dcl_id) (setq dcl_id (load_dialog "lampenbazar")))

  (while (> next 1)
  (new_dialog "lampenbazar" dcl_id)
(TE:lampenbazarTILE)
 
    (start_image "IMG1") 
    (slide_image 35 -30 220 115 fil1)
    (end_image)
  
    (action_tile "DIA" "(Te:lampenbazarDIA)")
    (action_tile "IMG1" "(Te:lampenbazarLogo)")
    (action_tile "DDH" "(setq DH (atoi $value))")
    (action_tile "DLH" "(setq LH (atoi $value))")
    (action_tile "DLuK" "(setq LuK (atoi $value))")
    (action_tile "DAnzeck" "(setq Anzeck (atoi $value))")
    (action_tile "DDo" "(setq Do (atoi $value))")
    (action_tile "DAbsOM" "(setq AbsOM (atoi $value))")
    (action_tile "DDmO" "(setq DmO (atoi $value))")
    (action_tile "DAbsMUM" "(setq AbsMUM (atoi $value))")
    (action_tile "DDmUM" "(setq DmUM (atoi $value))")  
    (action_tile "DAbsMU" "(setq AbsMU (atoi $value))")
    (action_tile "DDmU" "(setq DmU (atoi $value))")
    (action_tile "DDu" "(setq Du (atoi $value))")
    (action_tile "vView" "(done_dialog 5)")
    (action_tile "DLampein" "(setq Lampein (atoi $value))")
    (action_tile "DBodRein" "(setq BodRein (atoi $value))")
    (action_tile "DZO" "(setq ZO $value)")
    (action_tile "lampenbazar_INF" "(help \"lampenbazar.ahp\" \"lampenbazar\")")
    (action_tile "accept" "(done_dialog 1)")
    (action_tile "cancel" "(done_dialog 0)")
    
(setq next (start_dialog))
(if (= next 5)(lamp_grv))
(if (= next 1)(TE:lampenbazarZeich))
       (TE:lampenbazarBack)
  )
  (unload_dialog dcl_id)
)
(defun TE:lampenbazarTILE ()

  (setq brei (dimx_tile "DIA"))
  (setq hoe (dimy_tile "DIA"))
  (start_image "DIA")
  (fill_image 0 0 brei hoe -2)
  (slide_image 0 0 brei hoe (strcat "lampenbazar(lampenbazar_"Dn")"))
  (end_image)
  (set_tile "DDH" (rtos DH 2 0))
  (set_tile "DLH" (rtos LH 2 0))
  (set_tile "DLuK" (rtos Luk 2 0))
  (set_tile "DAnzeck" (rtos Anzeck 2 0))
  (set_tile "DDo" (rtos Do 2 0))
  (set_tile "DAbsOM" (rtos AbsOM 2 0))
  (set_tile "DDmO" (rtos DmO 2 0))
  (set_tile "DAbsMUM" (rtos AbsMUM 2 0))
  (set_tile "DDmUM" (rtos DmUM 2 0))
  (set_tile "DAbsMU" (rtos AbsMU 2 0))
  (set_tile "DDmU" (rtos DmU 2 0))
  (set_tile "DDu" (rtos Du 2 0))
  (set_tile "DZO" ZO)
  (set_tile "DLampein" (rtos Lampein 2 0))
  (set_tile "DBodRein" (rtos BodRein 2 0))
)
(defun TE:lampenbazarDIA ()
(cond ((= Dn "0") (setq Dn "1"))
      ((= Dn "1") (setq Dn "0"))
) 
(TE:lampenbazarTILE)
)
(defun TE:lampenbazarZeich ()
  (vl-load-com)
  (vl-cmdf "_.view" "S" "TE_VIEW")

  (setvar "OSMODE" 0)
  (vl-cmdf "_.UCS" "")
  (vl-cmdf "_.PLAN" "")
  (setq EP (getpoint "\n Einfgepunkt angeben \n "))
  (setq LampLay "TE_lampenbazarL_1" LampCLay "TE_lampenbazarC_1" LampBLay "TE_lampenbazarB_"
	a 0 b 0 NrL "1")

 (while (/= a 1)
  
  (if(= (cdr(assoc 2(tblsearch "LAYER" LampLay))) LampLay)
    (progn
      (setq  NrL (atoi(substr LampLay 17)))
      (setq  NrL (itoa(1+ NrL))) 
      (setq LampLay (strcat "TE_lampenbazarL_" NrL))

      (while (/= b 1)
	      
      (if(= (cdr(assoc 2(tblsearch "LAYER" LampLay))) LampLay)
	(progn
	  (setq  NrL (atoi(substr LampLay 17)))
      (setq  NrL (itoa(1+ NrL))) 
      (setq LampLay (strcat "TE_lampenbazarL_" NrL))
	(setq b 0)
	  )
	(setq b 1)
	)
      )
        (vl-cmdf "_.LAYER" "_M" LampLay "_CO" "51" LampLay "")
	(setq LampCLay (strcat "TE_lampenbazarC_" NrL))
	(vl-cmdf "_.LAYER" "_M" LampCLay "_CO" "5" LampCLay "")
        (setq a 1)
      )
	(progn  
	(vl-cmdf "_.LAYER" "_M" LampLay "_CO" "51" LampLay "")
	(vl-cmdf "_.LAYER" "_M" LampCLay "_CO" "5" LampCLay "")
	(setq a 1)
	)
    )
      )
  
  (Pu_berech)
  (setvar "SURFTAB1" Anzeck)
  (vl-cmdf "_LINE" EP Achsend "")  (setq Achs (entlast))
  (vl-cmdf "_PLINE" Lm1 Lm2 Lm3 Lm4 Lm5 "")
    (setvar "CLAYER" LampLay)

  (vl-cmdf "_revsurf" (entlast) Achs EP Achsend "")

  (arxload "geom3d")
 (rotate3d (entlast) "" EP Lm5 90)
(vl-cmdf "_.move" (entlast) "" EP (list (car EP)(cadr EP)(+(caddr EP)LuK)))

   (if (= Lampein 1)
     (vl-cmdf "_pointlight" (list (car EP)(cadr EP)(+(caddr EP)LuK 10.0)) "")
     )
  
  (if (= BodRein 1)
    	(progn
	  (setq tom 1)
	(setq LampBLay (strcat LampBLay NrL))
	(vl-cmdf "_.LAYER" "_M" LampBLay "_CO" "43" LampBLay "")
	  (vl-cmdf "_.box" "Mi" (list (car EP)(cadr EP)(-(caddr EP)(/ Di 2.0))) "L" LB LB Di)
	  )
    )
(vl-cmdf "_LAYER" "_FR" LampCLay "")
  (setvar "CECOLOR" coalt)
  (vl-cmdf "_.view" "H" "TE_VIEW")
  (vl-cmdf "_.zoom" "G" "_.zoom" "0.8x")
  (vl-cmdf "_.view" "L" "TE_VIEW")
  (if (= ZO "1")(Te:lampenbazarZom))
)
(defun Pu_berech ()
  (setq Wil (aib 180) Wio (aib 90.0) Wiu (aib 270.0) Wir 0.0)

  (setq Achsend (polar EP Wio LH))
  (setq Lm1 (list (+(car EP)(/ Do 2.0))(+(cadr EP)LH)(caddr EP))
	Lm2 (list (+(car EP)(/ DmO 2.0))(-(cadr Lm1)AbsOM)(caddr EP))
	Lm3 (list (+(car EP)(/ DmUM 2.0))(+(cadr EP)AbsMuM)(caddr EP))
	Lm4 (list (+(car EP)(/ DmU 2.0))(+(cadr EP)AbsMu)(caddr EP))
	Lm5 (list (+(car EP)(/ Du 2.0))(cadr EP)(caddr EP)))
 )
(defun lamp_grv ()
  (vl-cmdf "_vpoint" "d" 270.0 90.0)
  (redraw)
  (Pu_berech)
  (setq ZoEp (polar EP (aib 60)  LH))
  (command "_.zoom" "M" ZoEP (* LH 2.5))
   (grdraw EP Achsend 6)
  (grdraw Lm1 Lm2 3)(grdraw Lm2 Lm3 3)(grdraw Lm3 Lm4 3)(grdraw Lm4 Lm5 3)

(TE:lampenbazarTILE)
)
(defun Te:lampenbazarLogo ()
(alert (strcat "    Das Programm ist der Lampenbazar    \n
\t   Thomas Elbracht   \n \t te@elbracht-web.de  ") )
)
(defun Te:lampenbazarZom ()

  (vl-cmdf "_ZOOM" "_W" (getvar "EXTMIN") (getvar "EXTMAX"))
	(command "_ZOOM" "0.95x")
        (command "_REGEN")
)
(DEFUN aib (w) (* pi (/ w 180.0)))
(defun Te:lampenbazarBack ()
  (setvar "CMDECHO" cealt)
  (setvar "MENUECHO" mealt)
  (setvar "OSMODE"  osalt)
  (setvar "CLAYER"  layalt)
  (setvar "CECOLOR" coalt)
  (setvar "CELTSCALE" cesalt)
  (setvar "CELTYPE" celalt)
  (setvar "ORTHOMODE" ortalt)
  (setvar "DELOBJ" delalt)
  (setvar "SURFTAB1" surft1alt)
  (princ)
)
(defun C:lampenbazar ( / dcl_id cealt mealt osalt layalt coalt cesalt celalt delalt surft1alt
		      DH LH LuK Anzeck Do AbsOM DmO AbsMUM DmUM AbsMU DmU Du ZO BodRein Lampein
		      Dn EP next IMG1 fil1 brei hoe LampLay LampBLay LampCLay a b Wil Wio Wiu Wir
                      NrL Achsend Lm1 Lm2 Lm3 Lm4 Lm5 LB Di ZoEP)

  (Te:lampenbazarIni)

  (setq DH 2500 ; Deckenhhe
	LH 300  ; Lampenhhe
	LuK 2000; Lampenunterkante
	Anzeck (getvar "SURFTAB1"); eckig Lampe
        Do 50     ; Durchmesser oben    58
	AbsOM 80  ; Abstand oben mitte
	DmO 50    ; Durchmesser mitte 80
	AbsMUM 170 ; Abstand mitte von unten
	DmUM 70   ; Durchmesser mitte
        AbsMU 60  ; Abstand mitte unten
	DmU 180   ; Durchmesser mitte  250
	Du 100    ; Durchmesser unten
        ZO "1"    ; Zoomen
	BodRein 1 ; Boden einfgen
	LB 5000   ; Bodenlnge breite
	Di 50     ; Bodendicke
	Lampein 1 ; Punktlicht einfgen
        Dn "1"    ; Dianummer
        EP '(0.0 0.0 0.0)
	)

  (Te:lampenbazarDlg)
  (Te:lampenbazarBack)
(princ)
  )
  (princ "\n  Copyright (c) 2o25 Thomas Elbracht ")
  (princ "\n \t  Aufruf mit lampenbazar")
(princ)